import { type Theme } from '@mariozechner/pi-coding-agent';
interface Component {
    render(width: number): string[];
    handleInput?(data: string): void;
    invalidate(): void;
}
interface Focusable {
    focused: boolean;
}
interface TUIRef {
    requestRender(): void;
}
interface HubOverlayOptions {
    baseUrl: string;
    currentSessionId?: string;
    initialSessionId?: string;
    startInDetail?: boolean;
    done: (result: undefined) => void;
}
export declare class HubOverlay implements Component, Focusable {
    focused: boolean;
    private readonly tui;
    private readonly theme;
    private readonly done;
    private readonly baseUrl;
    private readonly currentSessionId?;
    private screen;
    private selectedIndex;
    private detailSessionId;
    private detailScrollOffset;
    private detailMaxScroll;
    private feedScrollOffset;
    private feedMaxScroll;
    private feedScope;
    private feedViewMode;
    private showFeedThinking;
    private feedFollowing;
    private taskScrollOffset;
    private taskMaxScroll;
    private selectedTaskIndex;
    private showTaskThinking;
    private taskFollowing;
    private sessions;
    private detail;
    private feed;
    private sessionFeed;
    private sessionBuffers;
    private taskBuffers;
    private hydratedSessions;
    private previousDigests;
    private loadingList;
    private loadingDetail;
    private listError;
    private detailError;
    private lastUpdatedAt;
    private listInFlight;
    private detailInFlight;
    private sseControllers;
    private disposed;
    private pollTimer;
    private mdRenderer;
    constructor(tui: TUIRef, theme: Theme, options: HubOverlayOptions);
    handleInput(data: string): void;
    render(width: number): string[];
    invalidate(): void;
    dispose(): void;
    private requestRender;
    private close;
    private handleListInput;
    private isSessionContext;
    private handleDetailInput;
    private handleFeedInput;
    private handleTaskInput;
    private getDetailTasks;
    private getSessionBuffer;
    private getTaskBuffer;
    private appendBufferText;
    private renderMarkdownLines;
    private renderStreamLines;
    private buildTopTabs;
    private fetchJson;
    private refreshList;
    private refreshDetail;
    private updateFeedFromList;
    private syncSseStreams;
    private startSseStream;
    private consumeSseBuffer;
    private handleSseEvent;
    private applyHydration;
    private applyStreamProjection;
    private captureStreamContent;
    private formatEventFeedLine;
    private getSessionLabel;
    private getFeedEntries;
    private pushFeed;
    private pushSessionFeed;
    private formatStreamLine;
    private getTaskFeedKey;
    private renderListScreen;
    private renderDetailScreen;
    private renderFeedScreen;
    private renderTaskScreen;
    private contentLine;
}
export {};
//# sourceMappingURL=hub-overlay.d.ts.map