/**
 * Coder footer for the Pi TUI.
 *
 * Uses transparent backgrounds with foreground-only ANSI true-color text.
 * Includes a braille spinner animation when an agent is actively working.
 *
 * Layout:
 *   [brand] [branch] > [model/agent]        [hub] | [N] label  token-stats
 *
 * Observer awareness (ASCII only):
 *   [3] SwiftRaven — 3 observers watching, session label "SwiftRaven"
 */
import type { ExtensionContext } from '@mariozechner/pi-coding-agent';
type HubStatus = 'connected' | 'reconnecting' | 'offline';
/** Observer state provided by the extension's presence tracking. */
export interface ObserverState {
    /** Number of observers watching this session (excludes lead + sub-agents). */
    count: number;
    /** Human-readable session label (e.g. "SwiftRaven"). */
    label: string;
}
/**
 * Set up the Coder footer (transparent bg, foreground-colored text).
 * Call this once with the extension context to replace Pi's default footer.
 *
 * Includes a braille spinner animation when an agent is actively working.
 *
 * @param ctx  Extension context with UI access
 * @param getHubStatus  Callback that returns current Hub connection status
 * @param getObserverState  Optional callback that returns observer count + session label
 */
export declare function setupCoderFooter(ctx: ExtensionContext, getHubStatus: () => HubStatus, getObserverState?: () => ObserverState): void;
export {};
//# sourceMappingURL=footer.d.ts.map