/**
 * Slash commands for routing to specific Coder Hub agents.
 *
 * Registers /lead, /memory, /product, etc. that prefix the user's
 * message with routing instructions so the lead agent delegates
 * to the specified agent.
 *
 * When the user types `/memory what happened last session`, the command
 * handler sends a user message with a routing prefix that the lead agent
 * recognizes and delegates accordingly.
 */
import type { ExtensionAPI, ExtensionCommandContext } from '@mariozechner/pi-coding-agent';
import type { AgentDefinition } from './protocol.ts';
type HubStatus = 'connected' | 'reconnecting' | 'offline';
/**
 * Register slash commands for each Hub agent.
 * When invoked, the command sends a user message prefixed with a routing directive
 * so the lead agent knows to delegate to the specified agent.
 */
export declare function registerAgentCommands(pi: ExtensionAPI, agents: AgentDefinition[], getHubStatus: () => HubStatus, openAgentManager?: (ctx: ExtensionCommandContext) => Promise<void>, openChainEditor?: (ctx: ExtensionCommandContext, initialAgents: string[]) => Promise<void>): void;
export {};
//# sourceMappingURL=commands.d.ts.map