import type { InitMessage, HubRequest, HubResponse } from './protocol.ts';
export type ConnectionState = 'connected' | 'disconnected' | 'reconnecting' | 'closed';
export declare class HubClient {
    private ws;
    private reconnectAttempts;
    private reconnectTimer;
    private intentionallyClosed;
    private lastConnectUrl;
    private queue;
    private connectionStateListeners;
    private pending;
    connectionState: ConnectionState;
    onConnectionStateChange?: (state: ConnectionState) => void;
    onBeforeReconnect?: () => Promise<void>;
    onInitMessage?: (initMessage: InitMessage) => void;
    /** Called when an unsolicited server message arrives (broadcast, presence, hydration). */
    onServerMessage?: (message: Record<string, unknown>) => void;
    private setConnectionState;
    private buildWebSocketUrl;
    private enqueue;
    private sendRequestNow;
    private sendFireAndForgetNow;
    private flushQueue;
    private handleUnexpectedClose;
    private clearReconnectTimer;
    private rejectQueuedRequests;
    private startReconnectLoop;
    private connectInternal;
    connect(url: string): Promise<InitMessage>;
    private waitForConnection;
    nextId(): string;
    send(request: HubRequest): Promise<HubResponse>;
    sendNoWait(message: HubRequest | Record<string, unknown>): void;
    waitUntilConnected(timeoutMs?: number): Promise<void>;
    close(): void;
    get connected(): boolean;
}
//# sourceMappingURL=client.d.ts.map