import type { Theme } from '@mariozechner/pi-coding-agent';
import type { AgentDefinition } from './protocol.ts';
export interface ChainResult {
    mode: 'sequential' | 'parallel';
    steps: Array<{
        agent: string;
        task: string;
    }>;
}
interface Component {
    render(width: number): string[];
    handleInput?(data: string): void;
    invalidate(): void;
}
interface Focusable {
    focused: boolean;
}
type DoneFn = (result: ChainResult | undefined) => void;
export declare class ChainEditorOverlay implements Component, Focusable {
    focused: boolean;
    private readonly theme;
    private readonly done;
    private readonly agentByName;
    private readonly availableAgents;
    private mode;
    private screen;
    private steps;
    private selectedStepIndex;
    private statusMessage;
    private readonly maxVisibleItems;
    private pickerIndex;
    private pickerFilter;
    private editBuffer;
    private editCursor;
    private previousTask;
    private disposed;
    constructor(theme: Theme, agents: AgentDefinition[], done: DoneFn, initialAgents?: string[]);
    handleInput(data: string): void;
    render(width: number): string[];
    invalidate(): void;
    dispose(): void;
    private buildInitialSteps;
    private handleComposeInput;
    private handlePickerInput;
    private handleEditInput;
    private getFilteredAgents;
    private renderComposeScreen;
    private renderPickerScreen;
    private contentLine;
    private getStepVisibleRange;
    private getPickerVisibleRange;
    private close;
}
export {};
//# sourceMappingURL=chain-preview.d.ts.map