import type { DBMessage, DBNonTextPart, DBSession, DBTextPart, DBTodo, DBToolCall, DBToolCallSummary, OpenCodeDBConfig, SessionCostSummary, SessionStatus, SessionTreeNode } from './types';
export declare class OpenCodeDBReader {
    private db;
    private available;
    private readonly config;
    private dbPath;
    private statements;
    constructor(config?: OpenCodeDBConfig);
    isAvailable(): boolean;
    open(): boolean;
    close(): void;
    getSession(id: string): DBSession | null;
    getChildSessions(parentId: string): DBSession[];
    getSessionsByProject(projectId: string): DBSession[];
    getSessionTree(rootId: string): SessionTreeNode;
    getMessages(sessionId: string, opts?: {
        limit?: number;
        offset?: number;
    }): DBMessage[];
    getLatestMessage(sessionId: string): DBMessage | null;
    getMessageCount(sessionId: string): number;
    getActiveToolCalls(sessionId: string): DBToolCall[];
    getToolCallHistory(sessionId: string, opts?: {
        limit?: number;
    }): DBToolCall[];
    getTextParts(sessionId: string, opts?: {
        limit?: number;
    }): DBTextPart[];
    /**
     * Get non-text parts (images, files, tool calls) for a session.
     * Useful for describing attachments during compaction.
     */
    getNonTextParts(sessionId: string): DBNonTextPart[];
    /**
     * Get recent tool calls for a session (newest first).
     * Returns concise summaries for compaction context.
     */
    getRecentToolCalls(sessionId: string, limit?: number): DBToolCallSummary[];
    getTodos(sessionId: string): DBTodo[];
    getSessionCost(sessionId: string): SessionCostSummary;
    getSessionStatus(sessionId: string): SessionStatus;
    searchSessions(query: string, opts?: {
        limit?: number;
    }): DBSession[];
    getSessionDashboard(parentSessionId: string): {
        sessions: SessionTreeNode[];
        totalCost: number;
    };
    private ensureOpen;
    private getStatement;
    private validateSchema;
    private buildSessionTree;
}
//# sourceMappingURL=reader.d.ts.map