export declare const QUERIES: {
    readonly CHECK_TABLES: "SELECT name FROM sqlite_master WHERE type='table' AND name IN ('session', 'message', 'part', 'todo')";
    readonly GET_SESSION: "SELECT * FROM session WHERE id = ?";
    readonly GET_CHILD_SESSIONS: "SELECT * FROM session WHERE parent_id = ? ORDER BY time_created DESC";
    readonly GET_SESSIONS_BY_PROJECT: "SELECT * FROM session WHERE project_id = ? ORDER BY time_created DESC";
    readonly GET_DESCENDANT_SESSIONS: "WITH RECURSIVE descendants AS (\n\t\tSELECT * FROM session WHERE parent_id = ?\n\t\tUNION ALL\n\t\tSELECT s.* FROM session s JOIN descendants d ON s.parent_id = d.id\n\t) SELECT * FROM descendants ORDER BY time_created DESC";
    readonly GET_MESSAGES: "SELECT * FROM message WHERE session_id = ? ORDER BY time_created DESC LIMIT ? OFFSET ?";
    readonly GET_LATEST_MESSAGE: "SELECT * FROM message WHERE session_id = ? ORDER BY time_created DESC LIMIT 1";
    readonly GET_MESSAGE_COUNT: "SELECT COUNT(*) as count FROM message WHERE session_id = ?";
    readonly GET_ACTIVE_TOOLS: "SELECT * FROM part WHERE session_id = ?\n\t\tAND json_valid(data)\n\t\tAND json_extract(data, '$.type') IN ('tool', 'tool-invocation') \n\t\tAND json_extract(data, '$.state.status') IN ('pending', 'running')\n\t\tORDER BY time_created DESC";
    readonly GET_TOOL_HISTORY: "SELECT * FROM part WHERE session_id = ?\n\t\tAND json_valid(data)\n\t\tAND json_extract(data, '$.type') IN ('tool', 'tool-invocation')\n\t\tORDER BY time_created DESC LIMIT ?";
    readonly GET_TEXT_PARTS: "SELECT * FROM part WHERE session_id = ?\n\t\tAND json_valid(data)\n\t\tAND json_extract(data, '$.type') = 'text'\n\t\tORDER BY time_created DESC LIMIT ?";
    readonly GET_TODOS: "SELECT * FROM todo WHERE session_id = ? ORDER BY position ASC";
    readonly GET_SESSION_COST: "SELECT \n\t\tCOALESCE(SUM(json_extract(data, '$.cost')), 0) as total_cost,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.total')), 0) as total_tokens,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.input')), 0) as input_tokens,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.output')), 0) as output_tokens,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.reasoning')), 0) as reasoning_tokens,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.cache.read')), 0) as cache_read,\n\t\tCOALESCE(SUM(json_extract(data, '$.tokens.cache.write')), 0) as cache_write,\n\t\tCOUNT(*) as message_count\n\t\tFROM message WHERE session_id = ? AND json_valid(data) AND json_extract(data, '$.role') = 'assistant'";
    readonly SEARCH_SESSIONS: "SELECT id, project_id, parent_id, slug, directory, title, version, share_url, summary_additions, summary_deletions, summary_files, summary_diffs, time_created, time_updated, time_compacting, time_archived FROM session WHERE title LIKE ? COLLATE NOCASE ORDER BY time_updated DESC";
    readonly SEARCH_SESSIONS_LIMITED: "SELECT id, project_id, parent_id, slug, directory, title, version, share_url, summary_additions, summary_deletions, summary_files, summary_diffs, time_created, time_updated, time_compacting, time_archived FROM session WHERE title LIKE ? COLLATE NOCASE ORDER BY time_updated DESC LIMIT ?";
    readonly GET_NON_TEXT_PARTS: "SELECT * FROM part WHERE session_id = ?\n\t\tAND json_valid(data)\n\t\tAND json_extract(data, '$.type') != 'text'\n\t\tORDER BY time_created DESC LIMIT ?";
};
//# sourceMappingURL=queries.d.ts.map