import type { LoadedSkill, SkillScope, SkillsConfig } from './types';
/**
 * Load skills from standard directories.
 * Priority order (later overrides earlier):
 * 1. User OpenCode: ~/.config/opencode/skills/
 * 2. User Agentuity: ~/.config/agentuity/opencode/skills/
 * 3. User Claude Code compat: ~/.claude/skills/
 * 4. Project OpenCode: ./.opencode/skills/
 * 5. Project Claude Code compat: ./.claude/skills/
 */
export declare function loadAllSkills(config?: SkillsConfig): Promise<LoadedSkill[]>;
/**
 * Load skills from a single directory
 */
export declare function loadSkillsFromDir(dir: string, scope: SkillScope): Promise<LoadedSkill[]>;
/**
 * Get skill by name from loaded skills
 */
export declare function getSkillByName(skills: LoadedSkill[], name: string): LoadedSkill | undefined;
//# sourceMappingURL=loader.d.ts.map