import type { PluginInput } from '@opencode-ai/plugin';
import type { CoderConfig } from '../../types';
export interface CompletionHooks {
    onParams: (input: unknown) => void;
    onMessage: (input: unknown) => void;
}
/**
 * Creates hooks for logging agent completion metrics.
 *
 * Tracks the start of each LLM call (via chat.params) and logs
 * agent name, model, and duration when the response arrives (via chat.message).
 */
export declare function createCompletionHooks(ctx: PluginInput, _config: CoderConfig): CompletionHooks;
//# sourceMappingURL=completion.d.ts.map