import type { OpenCodeDBReader } from '../../sqlite/reader';
import type { CompactionStats, PreCompactionSnapshot } from '../../sqlite/types';
/**
 * Get the current git branch name.
 * Moved here from cadence.ts and session-memory.ts to deduplicate.
 */
export declare function getCurrentBranch(): Promise<string>;
/**
 * Build the custom compaction prompt for our agent system.
 * This REPLACES the default OpenCode compaction prompt via output.prompt.
 */
export declare function buildCustomCompactionPrompt(mode: 'cadence' | 'regular'): string;
/**
 * Fetch planning state from KV and format as markdown.
 * Returns null if KV is unavailable or no planning state exists.
 */
export declare function fetchAndFormatPlanningState(sessionId: string): Promise<string | null>;
/**
 * Get image/attachment descriptions from SQLite for compaction context.
 * Returns brief metadata about non-text parts in the conversation.
 */
export declare function getImageDescriptions(dbReader: OpenCodeDBReader | null, sessionId: string): string | null;
/**
 * Get recent tool call summaries for compaction context.
 * CONCISE — capped at limit calls, brief descriptions only.
 */
export declare function getRecentToolCallSummaries(dbReader: OpenCodeDBReader | null, sessionId: string, limit?: number): string | null;
/**
 * Store a pre-compaction snapshot to KV as a recovery mechanism.
 */
export declare function storePreCompactionSnapshot(sessionId: string, snapshot: PreCompactionSnapshot): Promise<void>;
/**
 * Persist Cadence session state to KV for recovery after plugin restart.
 */
export declare function persistCadenceStateToKV(sessionId: string, state: Record<string, unknown>): Promise<void>;
/**
 * Restore Cadence session state from KV.
 */
export declare function restoreCadenceStateFromKV(sessionId: string): Promise<Record<string, unknown> | null>;
/**
 * Format compaction diagnostics — brief summary of what was preserved.
 */
export declare function formatCompactionDiagnostics(stats: CompactionStats): string;
/** Count markdown list items in a string */
export declare function countListItems(s: string | null): number;
export type { CompactionConfig } from '../../types';
export type { CompactionStats, DBNonTextPart, DBToolCallSummary, PreCompactionSnapshot, } from '../../sqlite/types';
//# sourceMappingURL=compaction-utils.d.ts.map