import type { PluginInput } from '@opencode-ai/plugin';
import type { CoderConfig } from '../../types';
import type { OpenCodeDBReader } from '../../sqlite';
/** Compacting hook input/output types */
type CompactingInput = {
    sessionID: string;
};
type CompactingOutput = {
    context: string[];
    prompt?: string;
};
export interface CadenceHooks {
    onMessage: (input: unknown, output: unknown) => Promise<void>;
    onEvent: (input: unknown) => Promise<void>;
    onCompacting: (input: CompactingInput, output: CompactingOutput) => Promise<void>;
    /** Check if a session is currently in Cadence mode */
    isActiveCadenceSession: (sessionId: string) => boolean;
    /** Lazy restore: check KV for persisted Cadence state and populate in-memory Map */
    tryRestoreFromKV: (sessionId: string) => Promise<boolean>;
}
/**
 * Cadence hooks track which sessions are in long-running Cadence mode.
 *
 * These hooks handle:
 * 1. Detect when Cadence mode starts (via command, [CADENCE MODE] tag, or ultrawork triggers)
 * 2. Detect when Cadence completes (via <promise>DONE</promise>)
 * 3. Inject context during compaction (experimental.session.compacting)
 * 4. Trigger continuation after compaction (session.compacted)
 * 5. Clean up on session abort/error
 */
export declare function createCadenceHooks(ctx: PluginInput, config: CoderConfig, dbReader?: OpenCodeDBReader, lastUserMessages?: Map<string, string>): CadenceHooks;
export {};
//# sourceMappingURL=cadence.d.ts.map