import { grepAppMcp } from './grep-app';
import { context7Mcp } from './context7';
export { grepAppMcp } from './grep-app';
export { context7Mcp } from './context7';
const allBuiltinMcps = {
    grep_app: grepAppMcp,
    context7: context7Mcp,
};
export function createBuiltinMcps(disabledMcps = []) {
    const mcps = {};
    const disabled = new Set(disabledMcps);
    for (const [name, config] of Object.entries(allBuiltinMcps)) {
        if (!disabled.has(name)) {
            mcps[name] = config;
        }
    }
    return mcps;
}
export function getMcp(name) {
    return allBuiltinMcps[name];
}
export function getAllMcps() {
    return Object.values(allBuiltinMcps);
}
//# sourceMappingURL=index.js.map