import { getProcessEnv } from './env';
export const buildUrl = (base, path, subpath, query) => {
    path = path.startsWith('/') ? path : `/${path}`;
    let url = base.replace(/\/$/, '') + path;
    if (subpath) {
        subpath = subpath.startsWith('/') ? subpath : `/${subpath}`;
        url += `/${subpath}`;
    }
    if (query) {
        url += `?${query.toString()}`;
    }
    return url;
};
const tryOrigin = () => {
    if (typeof window !== 'undefined') {
        return window.location.origin;
    }
};
export const defaultBaseUrl = getProcessEnv('NEXT_PUBLIC_AGENTUITY_URL') ||
    getProcessEnv('VITE_AGENTUITY_URL') ||
    getProcessEnv('AGENTUITY_URL') ||
    tryOrigin() ||
    'http://localhost:3500';
//# sourceMappingURL=url.js.map