import type { EventStreamClient } from './types';
/**
 * Create an EventSource (SSE) client wrapper with event-based API.
 *
 * Note: Native EventSource has limited authentication support.
 * - withCredentials: true will send cookies and HTTP auth headers
 * - For custom Authorization headers, consider using @microsoft/fetch-event-source
 */
export declare function createEventStreamClient(url: string, options?: {
    withCredentials?: boolean;
}): EventStreamClient;
//# sourceMappingURL=eventstream.d.ts.map