import type { InferOutput, StandardSchemaV1 } from '@agentuity/core';
import { type CreateEvalConfig, type EvalContext, type EvalHandlerResult } from '@agentuity/runtime';
import type { BaseEvalOptions, EvalLifecycleHooks, EvalMiddleware } from './types';
import { type LanguageModel } from 'ai';
export declare const DefaultEvalInputSchema: import("@agentuity/schema").ObjectSchema<{
    request: import("@agentuity/schema").StringSchema;
    context: import("@agentuity/schema").OptionalSchema<import("@agentuity/schema").StringSchema>;
}>;
export declare const DefaultEvalOutputSchema: import("@agentuity/schema").ObjectSchema<{
    response: import("@agentuity/schema").StringSchema;
}>;
export type DefaultEvalInput = typeof DefaultEvalInputSchema;
export type DefaultEvalOutput = typeof DefaultEvalOutputSchema;
/**
 * Interpolates a prompt template with the provided variables.
 * Replaces {{VARIABLE_NAME}} placeholders with their values.
 *
 * @example
 * ```typescript
 * const prompt = interpolatePrompt(politenessPrompt, {
 *   USER_REQUEST: input.request,
 *   MODEL_RESPONSE: output.response,
 * });
 * ```
 */
export declare function interpolatePrompt(template: string, variables: Record<string, string>): string;
export type GenerateEvalResultOptions = {
    model: LanguageModel;
    prompt: string;
    maxRetries?: number;
};
/**
 * Generates an eval result using LLM with built-in JSON parsing and validation retries.
 *
 * @example
 * ```typescript
 * const result = await generateEvalResult({
 *   model: options.model,
 *   prompt: interpolatePrompt(myPrompt, { ... }),
 * });
 * // result is typed as EvalHandlerResult
 * ```
 */
export declare function generateEvalResult(options: GenerateEvalResultOptions): Promise<EvalHandlerResult>;
type InferSchemaOutput<T> = T extends StandardSchemaV1 ? InferOutput<T> : any;
type PresetEvalOverrides<TEvalInput extends StandardSchemaV1 | undefined, TEvalOutput extends StandardSchemaV1 | undefined, TOptions extends BaseEvalOptions, TAgentInput, TAgentOutput> = Partial<{
    name?: string;
    description?: string;
} & TOptions> & {
    middleware?: EvalMiddleware<TAgentInput, TAgentOutput, InferSchemaOutput<TEvalInput>, InferSchemaOutput<TEvalOutput>>;
    /**
     * Called before the eval handler runs.
     */
    onStart?: EvalLifecycleHooks<TAgentInput, TAgentOutput>['onStart'];
    /**
     * Called after the eval handler completes successfully.
     */
    onComplete?: EvalLifecycleHooks<TAgentInput, TAgentOutput>['onComplete'];
};
type PresetEvalResult<TOptions extends BaseEvalOptions> = CreateEvalConfig<any, any> & {
    name: string;
    options: TOptions;
};
export declare function createPresetEval<TEvalInput extends StandardSchemaV1 | undefined = StandardSchemaV1 | undefined, TEvalOutput extends StandardSchemaV1 | undefined = StandardSchemaV1 | undefined, TOptions extends BaseEvalOptions = BaseEvalOptions>(config: {
    name: string;
    description?: string;
    handler: (ctx: EvalContext, input: InferSchemaOutput<TEvalInput>, output: InferSchemaOutput<TEvalOutput>, options: TOptions) => ReturnType<CreateEvalConfig<TEvalInput, TEvalOutput>['handler']>;
    options: TOptions;
}): <TAgentInput extends StandardSchemaV1 | undefined = any, TAgentOutput extends StandardSchemaV1 | undefined = any>(overrides?: PresetEvalOverrides<TEvalInput, TEvalOutput, TOptions, InferSchemaOutput<TAgentInput>, InferSchemaOutput<TAgentOutput>>) => PresetEvalResult<TOptions>;
export {};
//# sourceMappingURL=_utils.d.ts.map