import { FetchAdapter } from './adapter.ts';
export type TaskPriority = 'high' | 'medium' | 'low' | 'none';
export type TaskType = 'epic' | 'feature' | 'enhancement' | 'bug' | 'task';
export type TaskStatus = 'open' | 'in_progress' | 'closed';
export interface Task {
    id: string;
    created_at: string;
    updated_at: string;
    title: string;
    description?: string;
    metadata?: Record<string, unknown>;
    priority: TaskPriority;
    parent_id?: string;
    type: TaskType;
    status: TaskStatus;
    open_date?: string;
    in_progress_date?: string;
    closed_date?: string;
    created_id: string;
    assigned_id?: string;
    closed_id?: string;
}
export interface TaskChangelogEntry {
    id: string;
    created_at: string;
    task_id: string;
    field: string;
    old_value?: string;
    new_value?: string;
}
export interface CreateTaskParams {
    title: string;
    description?: string;
    metadata?: Record<string, unknown>;
    priority?: TaskPriority;
    parent_id?: string;
    type: TaskType;
    status?: TaskStatus;
    created_id: string;
    assigned_id?: string;
}
export interface UpdateTaskParams {
    title?: string;
    description?: string;
    metadata?: Record<string, unknown>;
    priority?: TaskPriority;
    parent_id?: string;
    type?: TaskType;
    status?: TaskStatus;
    assigned_id?: string;
    closed_id?: string;
}
export interface ListTasksParams {
    status?: TaskStatus;
    type?: TaskType;
    priority?: TaskPriority;
    assigned_id?: string;
    parent_id?: string;
    sort?: string;
    order?: 'asc' | 'desc';
    limit?: number;
    offset?: number;
}
export interface ListTasksResult {
    tasks: Task[];
    total: number;
    limit: number;
    offset: number;
}
export interface TaskChangelogResult {
    changelog: TaskChangelogEntry[];
    total: number;
    limit: number;
    offset: number;
}
export interface TaskStorage {
    create(params: CreateTaskParams): Promise<Task>;
    get(id: string): Promise<Task | null>;
    list(params?: ListTasksParams): Promise<ListTasksResult>;
    update(id: string, params: UpdateTaskParams): Promise<Task>;
    close(id: string): Promise<Task>;
    changelog(id: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<TaskChangelogResult>;
}
export declare class TaskStorageService implements TaskStorage {
    #private;
    constructor(baseUrl: string, adapter: FetchAdapter);
    create(params: CreateTaskParams): Promise<Task>;
    get(id: string): Promise<Task | null>;
    list(params?: ListTasksParams): Promise<ListTasksResult>;
    update(id: string, params: UpdateTaskParams): Promise<Task>;
    close(id: string): Promise<Task>;
    changelog(id: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<TaskChangelogResult>;
}
//# sourceMappingURL=task.d.ts.map