type PlainObject = Record<string, any>;
declare const _argsSym: unique symbol;
declare const _causeSym: unique symbol;
declare const _metaSym: unique symbol;
export declare class RichError extends Error {
    private [_argsSym]?;
    private [_causeSym]?;
    private [_metaSym]?;
    constructor(args?: PlainObject);
    /** Return the stored plain args (if any) */
    get plainArgs(): PlainObject | undefined;
    /** Return the cause (if any) */
    get cause(): unknown | undefined;
    /** Pretty, recursive string representation (follows cause chain). */
    prettyPrint(space?: number): string;
    toJSON(): any;
    toString(): string;
}
type StructuredErrorConstructor<Tag extends string, Shape extends PlainObject, HasDefault extends boolean> = {
    new (args?: Shape extends Record<string, never> ? HasDefault extends true ? {
        cause?: unknown;
    } : {
        message?: string;
        cause?: unknown;
    } : HasDefault extends true ? Shape & {
        cause?: unknown;
    } : Shape & {
        message?: string;
        cause?: unknown;
    }): RichError & {
        readonly _tag: Tag;
    } & Readonly<Shape>;
    readonly defaultMessage?: string;
};
/**
 * StructuredError factory with automatic tag inference and payload typing.
 *
 * Creates a custom error class with:
 * - A readonly `_tag` property for runtime type discrimination
 * - Automatic stack trace capture
 * - Cause chaining support
 * - Pretty printing with `prettyPrint()` and `toString()`
 * - JSON serialization with `toJSON()`
 *
 * @template Tag - The literal string tag type (automatically inferred from the tag parameter)
 * @param tag - The unique identifier for this error type (used as the error name)
 * @param defaultMessage - Optional default message to use when no message is provided in args
 * @returns A constructor function that can be called directly or with a shape generic
 *
 * @example
 * // Without shape (tag auto-inferred)
 * const NotFound = StructuredError("NotFound")
 * throw new NotFound({ id: 1, message: "nope", cause: someError })
 *
 * @example
 * // With typed shape (tag auto-inferred, shape explicitly typed)
 * const ValidationError = StructuredError("ValidationError")<{ field: string; code: string }>()
 * throw new ValidationError({ field: "email", code: "INVALID", message: "Invalid email" })
 *
 * @example
 * // With default message (message cannot be overridden)
 * const UpgradeRequired = StructuredError("UpgradeRequired", "Upgrade required to access this feature")
 * throw new UpgradeRequired({ feature: "advanced" }) // message is automatically set and cannot be changed
 */
type StructuredErrorFactory<Tag extends string, HasDefault extends boolean> = StructuredErrorConstructor<Tag, Record<string, never>, HasDefault> & (<Shape extends PlainObject = Record<string, never>>() => StructuredErrorConstructor<Tag, Shape, HasDefault>);
export declare function StructuredError<const Tag extends string>(tag: Tag, defaultMessage: string): StructuredErrorFactory<Tag, true>;
export declare function StructuredError<const Tag extends string>(tag: Tag): StructuredErrorFactory<Tag, false>;
/**
 * Returns true if the error passed is an instance of a StructuredObject
 *
 * @param err the error object
 * @returns true if err is a StructuredError
 *
 * @example
 * const UpgradeRequired = StructuredError("UpgradeRequired", "Upgrade required to access this feature")
 * try {
 *   throw UpgradeRequired();
 * } catch (ex) {
 *   if (isStructuredError(ex)) {
 *     console.log(ex._tag);
 *   }
 * }
 */
export declare function isStructuredError(err: unknown): err is RichError & {
    _tag: string;
};
export {};
//# sourceMappingURL=error.d.ts.map