import { createCommand } from '../../types';
import { apikeyCommand } from './apikey';
import { loginCommand } from './login';
import { logoutCommand } from './logout';
import { signupCommand } from './signup';
import { whoamiCommand } from './whoami';
import { sshSubcommand } from './ssh';
import { orgSubcommand } from './org';
import { getCommand } from '../../command-prefix';

export const command = createCommand({
	name: 'auth',
	description: 'Authentication and authorization related commands',
	tags: ['read-only', 'fast'],
	examples: [
		{ command: getCommand('auth login'), description: 'Login to your account' },
		{ command: getCommand('auth whoami'), description: 'Show current user info' },
		{ command: getCommand('auth org select'), description: 'Set default organization' },
	],
	subcommands: [
		apikeyCommand,
		loginCommand,
		logoutCommand,
		signupCommand,
		whoamiCommand,
		sshSubcommand,
		orgSubcommand,
	],
});
