/**
 * Abbreviate a string to a maximum length, adding ellipsis if truncated
 */
export function abbreviate(str, maxLength = 8) {
    if (!str)
        return 'N/A';
    if (str.length <= maxLength)
        return str;
    return str.slice(0, maxLength) + '...';
}
/**
 * Abbreviate a description (longer default length)
 */
export function abbreviateDescription(str, maxLength = 40) {
    if (!str)
        return 'N/A';
    if (str.length <= maxLength)
        return str;
    return str.slice(0, maxLength) + '...';
}
//# sourceMappingURL=format.js.map