export interface TextOptions {
    message: string;
    initial?: string;
    hint?: string;
    validate?: (value: string) => boolean | string | Promise<boolean | string>;
}
export interface ConfirmOptions {
    message: string;
    initial?: boolean;
}
export interface SelectOption<T = string> {
    value: T;
    label: string;
    hint?: string;
}
export interface SelectOptions<T = string> {
    message: string;
    options: SelectOption<T>[];
    initial?: T;
}
export interface MultiSelectOptions<T = string> {
    message: string;
    options: SelectOption<T>[];
    initial?: T[];
}
/**
 * Main prompt flow class
 */
export declare class PromptFlow {
    private states;
    private isInteractive;
    private nonInteractiveError;
    /**
     * Display intro banner
     */
    intro(title: string): void;
    /**
     * Display outro message
     */
    outro(...messages: string[]): void;
    /**
     * Text input prompt
     */
    text(options: TextOptions): Promise<string>;
    /**
     * Confirm (yes/no) prompt
     */
    confirm(options: ConfirmOptions): Promise<boolean>;
    /**
     * Select (single choice) prompt
     */
    select<T = string>(options: SelectOptions<T>): Promise<T>;
    /**
     * Multi-select (multiple choices) prompt
     */
    multiselect<T = string>(options: MultiSelectOptions<T>): Promise<T[]>;
    /**
     * Cancel the flow
     */
    cancel(message: string): void;
}
/**
 * Create a new prompt flow instance
 */
export declare function createPrompt(): PromptFlow;
//# sourceMappingURL=prompt.d.ts.map