/**
 * Grouped prompts orchestration
 */
/**
 * Execute a group of prompts sequentially
 */
export async function group(prompts, opts) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const results = {};
    const promptNames = Object.keys(prompts);
    for (const name of promptNames) {
        const prompt = prompts[name];
        try {
            const result = await prompt({ results });
            // Skip if undefined (conditional prompt)
            if (result === undefined) {
                continue;
            }
            results[name] = result;
        }
        catch (error) {
            // Handle cancellation
            if (opts?.onCancel) {
                results[name] = 'canceled';
                opts.onCancel({ results });
            }
            throw error;
        }
    }
    return results;
}
//# sourceMappingURL=group.js.map