export function isPossiblyJSON(val) {
    if (val) {
        if (typeof val === 'object') {
            return true;
        }
        if (typeof val === 'string') {
            const v = val.trim();
            if (v.startsWith('{') && v.endsWith('}')) {
                return true;
            }
            if (v.startsWith('[') && v.endsWith(']')) {
                return true;
            }
        }
    }
    return false;
}
export function tryParseJSON(val) {
    if (isPossiblyJSON(val)) {
        try {
            return JSON.parse(val);
        }
        catch {
            /* */
        }
    }
    return val;
}
//# sourceMappingURL=json.js.map