import type { Config } from './types';
interface BaseDNSResult {
    domain: string;
    target: string;
    recordType: string;
    aRecordTarget?: string;
}
interface DNSSuccess extends BaseDNSResult {
    success: true;
}
interface DNSPending extends BaseDNSResult {
    success: true;
    pending: true;
}
interface DNSMissing extends BaseDNSResult {
    success: false;
    pending: false;
}
interface DNSError extends BaseDNSResult {
    success: false;
    error: string;
}
interface DNSMisconfigured extends BaseDNSResult {
    success: false;
    misconfigured: string;
}
export type DNSResult = DNSSuccess | DNSPending | DNSMissing | DNSError | DNSMisconfigured;
export type DNSFailed = DNSPending | DNSMissing | DNSError | DNSMisconfigured;
export declare function isMisconfigured(x: DNSResult): x is DNSMisconfigured;
export declare function isMissing(x: DNSResult): x is DNSMissing;
export declare function isError(x: DNSResult): x is DNSError;
export declare function isPending(x: DNSResult): x is DNSPending;
export declare function isSuccess(x: DNSResult): x is DNSSuccess;
/**
 * This function will check for each of the custom domains and make sure they are correctly
 * configured in DNS
 *
 * @param projectId the project id
 * @param config Config
 * @param domains array of domains to check
 * @returns
 */
export declare function checkCustomDomainForDNS(projectId: string, domains: string[], region: string, config?: Config | null): Promise<DNSResult[]>;
export declare function promptForDNS(projectId: string, domains: string[], region: string, config?: Config, resumeFn?: () => () => void): Promise<void>;
export {};
//# sourceMappingURL=domain.d.ts.map