// Use dynamic imports for bundler compatibility while maintaining lazy loading
export async function discoverCommands() {
    const commandModules = await Promise.all([
        import('./ai').then((m) => m.command),
        import('./auth').then((m) => m.command),
        import('./build').then((m) => m.command),
        import('./canary').then((m) => m.command),
        import('./cloud').then((m) => m.command),
        import('./coder').then((m) => m.command),
        import('./dev').then((m) => m.command),
        import('./git').then((m) => m.gitCommand),
        import('./help').then((m) => m.command),
        import('./profile').then((m) => m.command),
        import('./project').then((m) => m.command),
        import('./repl').then((m) => m.command),
        import('./setup').then((m) => m.command),
        import('./support').then((m) => m.command),
        import('./upgrade').then((m) => m.command),
        import('./version').then((m) => m.command),
    ]);
    const commands = [];
    for (const cmd of commandModules) {
        commands.push(cmd);
        // Auto-create hidden top-level aliases for subcommands with toplevel: true
        if (cmd.subcommands) {
            for (const subcommand of cmd.subcommands) {
                if (subcommand.toplevel) {
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    const alias = {
                        name: subcommand.name,
                        description: subcommand.description,
                        aliases: subcommand.aliases,
                        hidden: true,
                        skipSkill: true,
                        requires: subcommand.requires,
                        optional: subcommand.optional,
                        schema: subcommand.schema,
                        handler: subcommand.handler,
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        idempotent: subcommand.idempotent,
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        prerequisites: subcommand.prerequisites,
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        tags: subcommand.tags,
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        examples: subcommand.examples,
                    };
                    commands.push(alias);
                }
            }
        }
    }
    return commands;
}
//# sourceMappingURL=index.js.map