/**
 * Hub URL resolution for Coder CLI commands.
 *
 * Resolution priority:
 *   1. --hub-url flag (explicit per-command override)
 *   2. AGENTUITY_CODER_HUB_URL env var
 *   3. AGENTUITY_DEVMODE_URL env var (dev tunnel URL)
 */
/**
 * Resolve the Hub HTTP base URL for REST API calls.
 * Converts ws:// URLs to http:// automatically.
 *
 * @param flagUrl  Optional --hub-url flag value
 * @returns HTTP base URL (e.g. "http://localhost:3500") or null if Hub is unreachable
 */
export declare function resolveHubUrl(flagUrl?: string): Promise<string | null>;
/**
 * Resolve the Hub WebSocket URL for Pi extension connections.
 * Converts http:// URLs to ws:// automatically and ensures /api/ws path.
 *
 * @param flagUrl  Optional --hub-url flag value
 * @returns WebSocket URL (e.g. "ws://127.0.0.1:3500/api/ws") or null
 */
export declare function resolveHubWsUrl(flagUrl?: string): Promise<string | null>;
//# sourceMappingURL=hub-url.d.ts.map