import type { Logger } from '@agentuity/core';
import { APIClient, type WebhookApiOptions } from '@agentuity/server';
import type { AuthData, Config, GlobalOptions } from '../../../types';
/**
 * Context required for webhook API operations.
 */
export interface WebhookContext {
    logger: Logger;
    auth: AuthData;
    config: Config | null;
    options: GlobalOptions;
    orgId?: string;
}
/**
 * Creates an API client for webhook operations.
 *
 * Webhooks are global resources that don't require a project context.
 * Uses the global Catalyst API client with user authentication.
 */
export declare function createWebhookAPIClient(ctx: WebhookContext): Promise<APIClient>;
/**
 * Creates WebhookApiOptions from the CLI context.
 * Prioritizes explicit orgId on context, then falls back to global --org-id option,
 * and finally to the preferred org from the profile configuration.
 */
export declare function getWebhookApiOptions(ctx: WebhookContext): WebhookApiOptions | undefined;
//# sourceMappingURL=util.d.ts.map