import { TaskStorageService } from '@agentuity/core';
import { createServerFetchAdapter } from '@agentuity/server';
import { getCatalystUrl } from '../../../catalyst';
import { setResourceInfo } from '../../../cache';
import { defaultProfileName, getDefaultRegion } from '../../../config';
import * as tui from '../../../tui';
export async function createStorageAdapter(ctx, explicitOrgId) {
    const orgId = explicitOrgId ??
        ctx.project?.orgId ??
        ctx.options.orgId ??
        (process.env.AGENTUITY_CLOUD_ORG_ID || ctx.config?.preferences?.orgId);
    if (!orgId) {
        tui.fatal('Organization ID is required. Either run from a project directory or use --org-id flag.');
    }
    const adapter = createServerFetchAdapter({
        headers: {
            Authorization: `Bearer ${ctx.auth.apiKey}`,
            'x-agentuity-orgid': orgId,
        },
    }, ctx.logger);
    // Task tenant DB is not regional — any Catalyst can serve the request.
    // Use provided region or fall back to default.
    const region = ctx.region ?? (await getDefaultRegion(ctx.config?.name ?? defaultProfileName, ctx.config));
    const baseUrl = getCatalystUrl(region);
    return new TaskStorageService(baseUrl, adapter);
}
export async function cacheTaskId(ctx, taskId) {
    const profileName = ctx.config?.name ?? defaultProfileName;
    const region = ctx.region ?? (await getDefaultRegion(profileName, ctx.config));
    const orgId = ctx.project?.orgId ??
        ctx.options.orgId ??
        (process.env.AGENTUITY_CLOUD_ORG_ID || ctx.config?.preferences?.orgId);
    await setResourceInfo('task', profileName, taskId, region, orgId);
}
export function parseMetadataFlag(raw) {
    if (!raw)
        return undefined;
    try {
        return JSON.parse(raw);
    }
    catch {
        tui.fatal('Invalid JSON for --metadata flag');
    }
}
//# sourceMappingURL=util.js.map