import { createCommand } from '../../../types';
import { runSubcommand } from './run';
import { createSubcommand } from './create';
import { execSubcommand } from './exec';
import { listSubcommand } from './list';
import { getSubcommand } from './get';
import { deleteSubcommand } from './delete';
import { snapshotCommand } from './snapshot';
import { runtimeCommand } from './runtime';
import { cpSubcommand } from './cp';
import { command as executionCommand } from './execution';
import { mkdirSubcommand } from './mkdir';
import { rmdirSubcommand } from './rmdir';
import { rmSubcommand } from './rm';
import { lsSubcommand } from './ls';
import { downloadSubcommand } from './download';
import { uploadSubcommand } from './upload';
import { envSubcommand } from './env';
import { pauseSubcommand } from './pause';
import { resumeSubcommand } from './resume';
import { getCommand } from '../../../command-prefix';
export const command = createCommand({
    name: 'sandbox',
    aliases: ['sb'],
    description: 'Manage sandboxes for managed isolated code execution',
    tags: ['slow', 'requires-auth'],
    examples: [
        {
            command: getCommand('cloud sandbox run -- echo "hello"'),
            description: 'Run a one-shot command in a sandbox',
        },
        {
            command: getCommand('cloud sandbox create'),
            description: 'Create an interactive sandbox',
        },
        {
            command: getCommand('cloud sandbox list'),
            description: 'List all sandboxes',
        },
    ],
    subcommands: [
        runSubcommand,
        createSubcommand,
        execSubcommand,
        listSubcommand,
        getSubcommand,
        deleteSubcommand,
        snapshotCommand,
        runtimeCommand,
        cpSubcommand,
        executionCommand,
        mkdirSubcommand,
        rmdirSubcommand,
        rmSubcommand,
        lsSubcommand,
        downloadSubcommand,
        uploadSubcommand,
        envSubcommand,
        pauseSubcommand,
        resumeSubcommand,
    ],
    requires: { auth: true, org: true },
});
export default command;
//# sourceMappingURL=index.js.map