/**
 * Deploy fork wrapper
 *
 * This module implements a fork-based deployment wrapper that:
 * 1. Spawns the deploy command as a child process using bunx
 * 2. Tees stdout/stderr to both the terminal and a Pulse stream
 * 3. On failure, sends diagnostics to the API
 *
 * This approach captures crashes, Bun runtime issues, and all output
 * for debugging failed deployments.
 */
import type { APIClient } from '../../api';
import { type ClientDiagnostics, type Deployment } from '@agentuity/server';
import type { Logger } from '@agentuity/core';
export interface ForkDeployOptions {
    projectDir: string;
    apiClient: APIClient;
    logger: Logger;
    sdkKey: string;
    deployment: Deployment;
    args: string[];
}
export interface ForkDeployResult {
    success: boolean;
    exitCode: number;
    diagnostics?: ClientDiagnostics;
}
/**
 * Run the deploy command as a forked child process
 */
export declare function runForkedDeploy(options: ForkDeployOptions): Promise<ForkDeployResult>;
//# sourceMappingURL=deploy-fork.d.ts.map