/**
 * Static Renderer
 *
 * When `render: 'static'` is set in agentuity.config.ts, this module:
 * 1. Runs a Vite SSR build to create a server-side entry point
 * 2. Imports the built entry-server.js
 * 3. Discovers routes to pre-render:
 *    - If `routeTree` is exported: auto-discovers all non-parameterized routes
 *    - If `getStaticPaths()` is exported: merges those paths in (for parameterized routes)
 *    - If neither: throws an error
 * 4. Calls render(url) for each route
 * 5. Replaces <!--app-html--> in the client template with rendered HTML
 * 6. Writes pre-rendered HTML files to .agentuity/client/
 */
import type { Logger } from '../../../types';
export interface StaticRenderOptions {
    rootDir: string;
    logger: Logger;
    /** User plugins from agentuity.config.ts */
    userPlugins: import('vite').PluginOption[];
}
export interface StaticRenderResult {
    routes: number;
    duration: number;
}
export declare function runStaticRender(options: StaticRenderOptions): Promise<StaticRenderResult>;
//# sourceMappingURL=static-renderer.d.ts.map