/**
 * Environment Types Generator
 *
 * Generates src/generated/env.d.ts by analyzing local .env files
 */
import type { Logger } from '../../../types';
export interface GenerateEnvTypesOptions {
    /** Root directory of the project */
    rootDir: string;
    /** Source directory (typically rootDir/src) */
    srcDir: string;
    /** Logger instance */
    logger: Logger;
    /** Whether building for production (affects .env file precedence) */
    isProduction: boolean;
    /** Optional config profile name (e.g., 'staging', 'test') for .env.{profile} files */
    profile?: string;
}
/**
 * Generate environment type definitions from local .env files
 *
 * @param options - Generation options
 * @returns true if types were generated, false if no env files found
 */
export declare function generateEnvTypes(options: GenerateEnvTypesOptions): Promise<boolean>;
//# sourceMappingURL=env-types-generator.d.ts.map