/**
 * Config loader for agentuity.config.ts
 */
import type { Logger } from '../../../types';
import type { AgentuityConfig } from '../../../types';
/**
 * Load agentuity.config.ts from the project root
 * Returns null if the file doesn't exist or fails to load
 */
export declare function loadAgentuityConfig(rootDir: string, logger: Logger): Promise<AgentuityConfig | null>;
/**
 * Get workbench configuration with defaults
 * NOTE: Workbench is only enabled at runtime in dev mode, but we need to know
 * if it's configured at build time so we can generate the correct code.
 *
 * Presence of workbench config implicitly enables it (no explicit 'enabled' flag needed)
 * Missing workbench config implicitly disables it
 */
export declare function getWorkbenchConfig(config: AgentuityConfig | null, dev: boolean): {
    configured: boolean;
    enabled: boolean;
    route: string;
    headers: Record<string, string>;
};
/**
 * Check if the user's plugins include any known UI-framework Vite plugin
 * (React, Svelte, Vue, Solid, Preact, …).
 *
 * Detection is name-based: Vite plugins expose a `name` property and every
 * major framework plugin uses a predictable prefix. This avoids dynamically
 * importing every possible framework just to compare names.
 */
export declare function hasFrameworkPlugin(userPlugins: import('vite').PluginOption[]): boolean;
//# sourceMappingURL=config-loader.d.ts.map