/**
 * Vite plugin to emit the analytics beacon as a hashed CDN asset
 *
 * This plugin:
 * 1. Reads the pre-built beacon from @agentuity/frontend
 * 2. Emits it as a Rollup asset with content-based hashing
 * 3. Injects a <script data-agentuity-beacon> tag into the HTML
 */
import type { Plugin } from 'vite';
export interface BeaconPluginOptions {
    /** Whether analytics is enabled */
    enabled: boolean;
}
/**
 * Vite plugin that emits the analytics beacon as a hashed asset
 * and injects a script tag into the HTML
 */
export declare function beaconPlugin(options: BeaconPluginOptions): Plugin;
//# sourceMappingURL=beacon-plugin.d.ts.map