/**
 * Agent Discovery - READ-ONLY AST analysis
 *
 * Discovers agents by scanning src/agent/**\/*.ts files
 * Extracts metadata WITHOUT mutating source files
 */
import type { Logger } from '../../../types';
export interface AgentMetadata {
    filename: string;
    name: string;
    id: string;
    agentId: string;
    version: string;
    description?: string;
    inputSchemaCode?: string;
    outputSchemaCode?: string;
    evals?: EvalMetadata[];
}
export interface EvalMetadata {
    id: string;
    identifier: string;
    name: string;
    filename: string;
    version: string;
    description?: string;
    agentIdentifier: string;
    projectId: string;
}
/**
 * Discover all agents in src/agent directory (READ-ONLY)
 */
export declare function discoverAgents(srcDir: string, projectId: string, deploymentId: string, logger: Logger): Promise<AgentMetadata[]>;
//# sourceMappingURL=agent-discovery.d.ts.map