/**
 * Vite-based bundler
 *
 * Replaces the Bun bundler with Vite for client and server builds
 */
import type { Logger, DeployOptions } from '../../types';
import type { BuildReportCollector } from '../../build-report';
export interface ViteBundleOptions {
    rootDir: string;
    dev?: boolean;
    projectId?: string;
    orgId?: string;
    region?: string;
    deploymentId?: string;
    port?: number;
    logger: Logger;
    deploymentOptions?: DeployOptions;
    /** Deployment config from agentuity.json (resources, mode, dependencies, domains) */
    deploymentConfig?: Record<string, unknown>;
    /** Optional collector for structured error reporting */
    collector?: BuildReportCollector;
}
/**
 * Bundle the project using Vite
 */
export declare function viteBundle(options: ViteBundleOptions): Promise<{
    output: string[];
}>;
//# sourceMappingURL=vite-bundler.d.ts.map