/**
 * Prompt file versioning utilities.
 *
 * Hash format at end of file: <!-- prompt_hash: [hash] -->
 *
 * - hash: SHA256 of file content (excluding the hash line)
 *
 * This allows detecting if the source template has changed.
 */
/**
 * Compute SHA256 hash of content using Bun's built-in hasher.
 */
export declare function computeHash(content: string): string;
/**
 * Strip the hash comment from content.
 */
export declare function stripHashComment(content: string): string;
/**
 * Extract hash from file content.
 * Returns null if no hash comment found.
 */
export declare function extractHash(content: string): string | null;
/**
 * Generate content with hash comment appended.
 * Ensures the output ends with a newline for POSIX compliance and Prettier compatibility.
 */
export declare function appendHashComment(content: string): string;
/**
 * Check if a file needs to be updated based on hash comparison.
 *
 * @param fileContent - Current file content (with hash comment)
 * @param sourceContent - Source template content (without hash comment)
 * @returns true if file needs to be updated (hashes differ)
 */
export declare function needsUpdate(fileContent: string, sourceContent: string): boolean;
//# sourceMappingURL=version.d.ts.map