export type ResourceType = 'sandbox' | 'bucket' | 'db' | 'project' | 'deployment' | 'machine' | 'queue' | 'vector' | 'kv' | 'stream' | 'webhook' | 'task';
/**
 * Resource info returned from cache lookup
 */
export interface ResourceInfo {
    region: string;
    orgId?: string;
    projectId?: string;
}
/**
 * Get the cached info (region and orgId) for a resource.
 * Returns null if not found or expired.
 */
export declare function getResourceInfo(type: ResourceType, profile: string, id: string): Promise<ResourceInfo | null>;
/**
 * Get the cached region for a resource.
 * Returns null if not found or expired.
 * @deprecated Use getResourceInfo() to get both region and orgId
 */
export declare function getResourceRegion(type: ResourceType, profile: string, id: string): Promise<string | null>;
/**
 * Set the cached info for a resource.
 * Uses INSERT OR REPLACE to upsert.
 */
export declare function setResourceInfo(type: ResourceType, profile: string, id: string, region: string, orgId?: string, projectId?: string): Promise<void>;
/**
 * Set the cached region for a resource.
 * Uses INSERT OR REPLACE to upsert.
 * @deprecated Use setResourceInfo() to set both region and orgId
 */
export declare function setResourceRegion(type: ResourceType, profile: string, id: string, region: string): Promise<void>;
/**
 * Delete the cached info for a resource.
 * Called when a resource is deleted.
 */
export declare function deleteResourceRegion(type: ResourceType, profile: string, id: string): Promise<void>;
/**
 * Clear all cached entries for a specific profile.
 * Useful when switching profiles or logging out.
 */
export declare function clearProfileCache(profile: string): Promise<void>;
/**
 * Close the database connection.
 * Should be called on CLI exit for clean shutdown.
 */
export declare function closeDatabase(): void;
//# sourceMappingURL=resource-region.d.ts.map