/**
 * Check if an agent has already seen the intro message.
 * This is a synchronous operation for use in formatHelp.
 * Returns true on error to avoid blocking CLI (assumes seen).
 */
export declare function hasAgentSeenIntro(agentId: string): boolean;
/**
 * Mark an agent as having seen the intro message.
 * This is a synchronous operation for use in formatHelp.
 * Silently fails on error (non-critical feature).
 */
export declare function markAgentIntroSeen(agentId: string): void;
//# sourceMappingURL=agent-intro.d.ts.map