/**
 * CLI-specific API client wrapper
 *
 * Re-exports from @agentuity/server with CLI-specific configuration
 */
import type { Config, Logger } from './types';
import { APIClient as BaseAPIClient } from '@agentuity/server';
export declare function getUserAgent(config?: Config | null): string;
export declare class APIClient extends BaseAPIClient {
    constructor(baseUrl: string, logger: Logger, config?: Config | null);
    constructor(baseUrl: string, logger: Logger, apiKey: string, config?: Config | null);
}
export declare function getAPIBaseURL(config?: Config | null): string;
export declare function getAppBaseURL(config?: Config | null): string;
export declare function getGravityDevModeURL(region: string, config?: Config | null): string;
//# sourceMappingURL=api.d.ts.map