import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Settings } from 'lucide-react';
import { cn } from '../../lib/utils';
import { Button } from '../ui/button';
import { ThemeToggle } from '../ui/theme-toggle';
import Logo from './logo';
import { useWorkbench } from './workbench-provider';
export function Header({ className, title = 'Workbench', showSettings = false }) {
    const { connectionStatus } = useWorkbench();
    return (_jsxs("nav", { className: cn('flex items-center justify-between gap-6 py-2 px-4 border-b', className), children: [_jsxs("div", { className: "flex items-center gap-2.5", children: [_jsx(Logo, {}), _jsx("h1", { className: "text-sm", children: title })] }), _jsxs("div", { className: "flex items-center gap-3", children: [_jsx(StatusIndicator, { status: connectionStatus }), _jsxs("div", { className: "flex items-center gap-1", children: [_jsx(ThemeToggle, {}), showSettings && (_jsx(Button, { size: "icon", variant: "ghost", children: _jsx(Settings, {}) }))] })] })] }));
}
export function StatusIndicator({ status }) {
    if (status === 'connected') {
        return (_jsxs("div", { className: "flex items-center gap-1.5 text-xs text-green-600 dark:text-green-400", children: [_jsx("div", { className: "size-2 rounded-full bg-green-500 animate-pulse" }), _jsx("span", { children: "Connected" })] }));
    }
    if (status === 'restarting') {
        return (_jsxs("div", { className: "flex items-center gap-1.5 text-xs text-amber-600 dark:text-amber-400", children: [_jsx("div", { className: "size-2 rounded-full bg-amber-500 animate-pulse" }), _jsx("span", { children: "Restarting..." })] }));
    }
    if (status === 'disconnected') {
        return (_jsxs("div", { className: "flex items-center gap-1.5 text-xs text-red-600 dark:text-red-400", children: [_jsx("div", { className: "size-2 rounded-full bg-red-500" }), _jsx("span", { children: "Disconnected" })] }));
    }
    return null;
}
export default Header;
//# sourceMappingURL=header.js.map