import type { SandboxInfo } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api';
export declare const SandboxResourcesSchema: z.ZodObject<{
    memory: z.ZodOptional<z.ZodString>;
    cpu: z.ZodOptional<z.ZodString>;
    disk: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxUserInfoSchema: z.ZodObject<{
    id: z.ZodString;
    firstName: z.ZodOptional<z.ZodString>;
    lastName: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxAgentInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
export declare const SandboxProjectInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
export declare const SandboxOrgInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
export declare const SandboxRuntimeInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    iconUrl: z.ZodOptional<z.ZodString>;
    brandColor: z.ZodOptional<z.ZodString>;
    tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const SandboxSnapshotUserInfoSchema: z.ZodObject<{
    id: z.ZodString;
    firstName: z.ZodOptional<z.ZodString>;
    lastName: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxSnapshotOrgInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    slug: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxSnapshotInfoSchema: z.ZodUnion<readonly [z.ZodObject<{
    id: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    fullName: z.ZodOptional<z.ZodString>;
    public: z.ZodLiteral<true>;
    org: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        slug: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodObject<{
    id: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    fullName: z.ZodOptional<z.ZodString>;
    public: z.ZodLiteral<false>;
    user: z.ZodObject<{
        id: z.ZodString;
        firstName: z.ZodOptional<z.ZodString>;
        lastName: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>]>;
export declare const SandboxInfoDataSchema: z.ZodObject<{
    sandboxId: z.ZodString;
    identifier: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    status: z.ZodEnum<{
        idle: "idle";
        failed: "failed";
        deleted: "deleted";
        creating: "creating";
        running: "running";
        terminated: "terminated";
    }>;
    mode: z.ZodOptional<z.ZodString>;
    createdAt: z.ZodString;
    region: z.ZodOptional<z.ZodString>;
    runtime: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        iconUrl: z.ZodOptional<z.ZodString>;
        brandColor: z.ZodOptional<z.ZodString>;
        tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>>;
    snapshot: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        id: z.ZodString;
        name: z.ZodOptional<z.ZodString>;
        tag: z.ZodOptional<z.ZodString>;
        fullName: z.ZodOptional<z.ZodString>;
        public: z.ZodLiteral<true>;
        org: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            slug: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>;
    }, z.core.$strip>, z.ZodObject<{
        id: z.ZodString;
        name: z.ZodOptional<z.ZodString>;
        tag: z.ZodOptional<z.ZodString>;
        fullName: z.ZodOptional<z.ZodString>;
        public: z.ZodLiteral<false>;
        user: z.ZodObject<{
            id: z.ZodString;
            firstName: z.ZodOptional<z.ZodString>;
            lastName: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>;
    }, z.core.$strip>]>>;
    executions: z.ZodNumber;
    exitCode: z.ZodOptional<z.ZodNumber>;
    stdoutStreamUrl: z.ZodOptional<z.ZodString>;
    stderrStreamUrl: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    packages: z.ZodOptional<z.ZodArray<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    resources: z.ZodOptional<z.ZodObject<{
        memory: z.ZodOptional<z.ZodString>;
        cpu: z.ZodOptional<z.ZodString>;
        disk: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    cpuTimeMs: z.ZodOptional<z.ZodNumber>;
    memoryByteSec: z.ZodOptional<z.ZodNumber>;
    networkEgressBytes: z.ZodOptional<z.ZodNumber>;
    networkEnabled: z.ZodOptional<z.ZodBoolean>;
    networkPort: z.ZodOptional<z.ZodNumber>;
    url: z.ZodOptional<z.ZodString>;
    user: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        firstName: z.ZodOptional<z.ZodString>;
        lastName: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    agent: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
    project: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
    org: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>;
    timeout: z.ZodOptional<z.ZodObject<{
        idle: z.ZodOptional<z.ZodString>;
        execution: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    command: z.ZodOptional<z.ZodObject<{
        exec: z.ZodArray<z.ZodString>;
        mode: z.ZodOptional<z.ZodEnum<{
            oneshot: "oneshot";
            interactive: "interactive";
        }>>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const SandboxGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        sandboxId: z.ZodString;
        identifier: z.ZodOptional<z.ZodString>;
        name: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        status: z.ZodEnum<{
            idle: "idle";
            failed: "failed";
            deleted: "deleted";
            creating: "creating";
            running: "running";
            terminated: "terminated";
        }>;
        mode: z.ZodOptional<z.ZodString>;
        createdAt: z.ZodString;
        region: z.ZodOptional<z.ZodString>;
        runtime: z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            iconUrl: z.ZodOptional<z.ZodString>;
            brandColor: z.ZodOptional<z.ZodString>;
            tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
        }, z.core.$strip>>;
        snapshot: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            id: z.ZodString;
            name: z.ZodOptional<z.ZodString>;
            tag: z.ZodOptional<z.ZodString>;
            fullName: z.ZodOptional<z.ZodString>;
            public: z.ZodLiteral<true>;
            org: z.ZodObject<{
                id: z.ZodString;
                name: z.ZodString;
                slug: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>;
        }, z.core.$strip>, z.ZodObject<{
            id: z.ZodString;
            name: z.ZodOptional<z.ZodString>;
            tag: z.ZodOptional<z.ZodString>;
            fullName: z.ZodOptional<z.ZodString>;
            public: z.ZodLiteral<false>;
            user: z.ZodObject<{
                id: z.ZodString;
                firstName: z.ZodOptional<z.ZodString>;
                lastName: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>;
        }, z.core.$strip>]>>;
        executions: z.ZodNumber;
        exitCode: z.ZodOptional<z.ZodNumber>;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
        dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
        packages: z.ZodOptional<z.ZodArray<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        resources: z.ZodOptional<z.ZodObject<{
            memory: z.ZodOptional<z.ZodString>;
            cpu: z.ZodOptional<z.ZodString>;
            disk: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        cpuTimeMs: z.ZodOptional<z.ZodNumber>;
        memoryByteSec: z.ZodOptional<z.ZodNumber>;
        networkEgressBytes: z.ZodOptional<z.ZodNumber>;
        networkEnabled: z.ZodOptional<z.ZodBoolean>;
        networkPort: z.ZodOptional<z.ZodNumber>;
        url: z.ZodOptional<z.ZodString>;
        user: z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            firstName: z.ZodOptional<z.ZodString>;
            lastName: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        agent: z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        project: z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        org: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>;
        timeout: z.ZodOptional<z.ZodObject<{
            idle: z.ZodOptional<z.ZodString>;
            execution: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        command: z.ZodOptional<z.ZodObject<{
            exec: z.ZodArray<z.ZodString>;
            mode: z.ZodOptional<z.ZodEnum<{
                oneshot: "oneshot";
                interactive: "interactive";
            }>>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface SandboxGetParams {
    sandboxId: string;
    orgId?: string;
    includeDeleted?: boolean;
}
/**
 * Retrieves information about a specific sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID
 * @returns Sandbox information including status, creation time, and execution count
 * @throws {SandboxResponseError} If the sandbox is not found or request fails
 */
export declare function sandboxGet(client: APIClient, params: SandboxGetParams): Promise<SandboxInfo>;
//# sourceMappingURL=get.d.ts.map