import type { SandboxCreateOptions, SandboxStatus } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api';
export declare const SandboxCreateRequestSchema: z.ZodObject<{
    projectId: z.ZodOptional<z.ZodString>;
    runtime: z.ZodOptional<z.ZodString>;
    runtimeId: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    resources: z.ZodOptional<z.ZodObject<{
        memory: z.ZodOptional<z.ZodString>;
        cpu: z.ZodOptional<z.ZodString>;
        disk: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    network: z.ZodOptional<z.ZodObject<{
        enabled: z.ZodOptional<z.ZodBoolean>;
        port: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>>;
    stream: z.ZodOptional<z.ZodObject<{
        stdout: z.ZodOptional<z.ZodString>;
        stderr: z.ZodOptional<z.ZodString>;
        stdin: z.ZodOptional<z.ZodString>;
        timestamps: z.ZodOptional<z.ZodBoolean>;
    }, z.core.$strip>>;
    timeout: z.ZodOptional<z.ZodObject<{
        idle: z.ZodOptional<z.ZodString>;
        execution: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    command: z.ZodOptional<z.ZodObject<{
        exec: z.ZodArray<z.ZodString>;
        files: z.ZodOptional<z.ZodArray<z.ZodObject<{
            path: z.ZodString;
            content: z.ZodString;
        }, z.core.$strip>>>;
        mode: z.ZodOptional<z.ZodEnum<{
            oneshot: "oneshot";
            interactive: "interactive";
        }>>;
    }, z.core.$strip>>;
    files: z.ZodOptional<z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        content: z.ZodString;
    }, z.core.$strip>>>;
    snapshot: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    packages: z.ZodOptional<z.ZodArray<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>;
export declare const SandboxCreateDataSchema: z.ZodObject<{
    sandboxId: z.ZodString;
    status: z.ZodEnum<{
        idle: "idle";
        failed: "failed";
        creating: "creating";
        running: "running";
        terminated: "terminated";
    }>;
    stdoutStreamId: z.ZodOptional<z.ZodString>;
    stdoutStreamUrl: z.ZodOptional<z.ZodString>;
    stderrStreamId: z.ZodOptional<z.ZodString>;
    stderrStreamUrl: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxCreateResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        sandboxId: z.ZodString;
        status: z.ZodEnum<{
            idle: "idle";
            failed: "failed";
            creating: "creating";
            running: "running";
            terminated: "terminated";
        }>;
        stdoutStreamId: z.ZodOptional<z.ZodString>;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamId: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface SandboxCreateResponse {
    sandboxId: string;
    status: SandboxStatus;
    stdoutStreamId?: string;
    stdoutStreamUrl?: string;
    stderrStreamId?: string;
    stderrStreamUrl?: string;
}
export interface SandboxCreateParams {
    options?: SandboxCreateOptions;
    orgId?: string;
}
/**
 * Creates a new sandbox instance.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters for creating the sandbox
 * @returns The created sandbox response including sandbox ID and stream URLs
 * @throws {SandboxResponseError} If the sandbox creation fails
 */
export declare function sandboxCreate(client: APIClient, params?: SandboxCreateParams): Promise<SandboxCreateResponse>;
//# sourceMappingURL=create.d.ts.map