import { z } from 'zod';
import { type APIClient } from '../api';
export declare const PackageRefSchema: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
}, z.core.$strip>;
export type PackageRef = z.infer<typeof PackageRefSchema>;
export declare const MalwareFindingSchema: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
    reason: z.ZodString;
}, z.core.$strip>;
export type MalwareFinding = z.infer<typeof MalwareFindingSchema>;
export declare const MalwareCheckSummarySchema: z.ZodObject<{
    scanned: z.ZodNumber;
    flagged: z.ZodNumber;
}, z.core.$strip>;
export declare const MalwareCheckListMetadataSchema: z.ZodObject<{
    fetchedAt: z.ZodString;
    count: z.ZodNumber;
}, z.core.$strip>;
export declare const MalwareCheckResultSchema: z.ZodObject<{
    action: z.ZodEnum<{
        allow: "allow";
        block: "block";
    }>;
    summary: z.ZodObject<{
        scanned: z.ZodNumber;
        flagged: z.ZodNumber;
    }, z.core.$strip>;
    findings: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        reason: z.ZodString;
    }, z.core.$strip>>;
    list: z.ZodOptional<z.ZodObject<{
        fetchedAt: z.ZodString;
        count: z.ZodNumber;
    }, z.core.$strip>>;
    error: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const MalwareCheckResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        action: z.ZodEnum<{
            allow: "allow";
            block: "block";
        }>;
        summary: z.ZodObject<{
            scanned: z.ZodNumber;
            flagged: z.ZodNumber;
        }, z.core.$strip>;
        findings: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            version: z.ZodString;
            reason: z.ZodString;
        }, z.core.$strip>>;
        list: z.ZodOptional<z.ZodObject<{
            fetchedAt: z.ZodString;
            count: z.ZodNumber;
        }, z.core.$strip>>;
        error: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type MalwareCheckResult = z.infer<typeof MalwareCheckResultSchema>;
export declare function projectDeploymentMalwareCheck(client: APIClient, deploymentId: string, packages: PackageRef[], signal?: AbortSignal): Promise<MalwareCheckResult>;
//# sourceMappingURL=malware.d.ts.map