import { z } from 'zod';
import { type APIClient } from '../api';
export declare const Resources: z.ZodObject<{
    memory: z.ZodDefault<z.ZodString>;
    cpu: z.ZodDefault<z.ZodString>;
    disk: z.ZodDefault<z.ZodString>;
}, z.core.$strip>;
export declare const Mode: z.ZodObject<{
    type: z.ZodDefault<z.ZodEnum<{
        "on-demand": "on-demand";
        provisioned: "provisioned";
    }>>;
    idle: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const DeploymentConfig: z.ZodObject<{
    resources: z.ZodOptional<z.ZodObject<{
        memory: z.ZodDefault<z.ZodString>;
        cpu: z.ZodDefault<z.ZodString>;
        disk: z.ZodDefault<z.ZodString>;
    }, z.core.$strip>>;
    mode: z.ZodOptional<z.ZodObject<{
        type: z.ZodDefault<z.ZodEnum<{
            "on-demand": "on-demand";
            provisioned: "provisioned";
        }>>;
        idle: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    domains: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const BuildEvalSchema: z.ZodObject<{
    id: z.ZodString;
    identifier: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    agentIdentifier: z.ZodString;
    projectId: z.ZodString;
    filename: z.ZodString;
    version: z.ZodString;
}, z.core.$strip>;
export declare const BuildAgentSchema: z.ZodObject<{
    id: z.ZodString;
    agentId: z.ZodString;
    projectId: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    evals: z.ZodOptional<z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        identifier: z.ZodString;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        agentIdentifier: z.ZodString;
        projectId: z.ZodString;
        filename: z.ZodString;
        version: z.ZodString;
    }, z.core.$strip>>>;
    schema: z.ZodOptional<z.ZodObject<{
        input: z.ZodOptional<z.ZodString>;
        output: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    filename: z.ZodString;
    version: z.ZodString;
}, z.core.$strip>;
export declare const BuildMetadataSchema: z.ZodObject<{
    routes: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        filename: z.ZodString;
        path: z.ZodString;
        method: z.ZodEnum<{
            get: "get";
            post: "post";
            put: "put";
            delete: "delete";
            patch: "patch";
        }>;
        version: z.ZodString;
        type: z.ZodEnum<{
            api: "api";
            sms: "sms";
            email: "email";
            cron: "cron";
            websocket: "websocket";
            sse: "sse";
            stream: "stream";
        }>;
        agentIds: z.ZodOptional<z.ZodArray<z.ZodString>>;
        config: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        schema: z.ZodOptional<z.ZodObject<{
            input: z.ZodOptional<z.ZodString>;
            output: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    agents: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        agentId: z.ZodString;
        projectId: z.ZodString;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        evals: z.ZodOptional<z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            identifier: z.ZodString;
            name: z.ZodString;
            description: z.ZodOptional<z.ZodString>;
            agentIdentifier: z.ZodString;
            projectId: z.ZodString;
            filename: z.ZodString;
            version: z.ZodString;
        }, z.core.$strip>>>;
        schema: z.ZodOptional<z.ZodObject<{
            input: z.ZodOptional<z.ZodString>;
            output: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        filename: z.ZodString;
        version: z.ZodString;
    }, z.core.$strip>>;
    assets: z.ZodArray<z.ZodObject<{
        filename: z.ZodString;
        kind: z.ZodString;
        contentType: z.ZodString;
        contentEncoding: z.ZodOptional<z.ZodString>;
        size: z.ZodNumber;
    }, z.core.$strip>>;
    project: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        version: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        keywords: z.ZodOptional<z.ZodArray<z.ZodString>>;
        orgId: z.ZodString;
    }, z.core.$strip>;
    deployment: z.ZodIntersection<z.ZodObject<{
        resources: z.ZodOptional<z.ZodObject<{
            memory: z.ZodDefault<z.ZodString>;
            cpu: z.ZodDefault<z.ZodString>;
            disk: z.ZodDefault<z.ZodString>;
        }, z.core.$strip>>;
        mode: z.ZodOptional<z.ZodObject<{
            type: z.ZodDefault<z.ZodEnum<{
                "on-demand": "on-demand";
                provisioned: "provisioned";
            }>>;
            idle: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
        domains: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>, z.ZodObject<{
        id: z.ZodString;
        date: z.ZodString;
        git: z.ZodOptional<z.ZodObject<{
            repo: z.ZodOptional<z.ZodString>;
            commit: z.ZodOptional<z.ZodString>;
            message: z.ZodOptional<z.ZodString>;
            branch: z.ZodOptional<z.ZodString>;
            tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
            pr: z.ZodOptional<z.ZodString>;
            provider: z.ZodOptional<z.ZodString>;
            trigger: z.ZodOptional<z.ZodDefault<z.ZodString>>;
            url: z.ZodOptional<z.ZodString>;
            buildUrl: z.ZodOptional<z.ZodString>;
            event: z.ZodOptional<z.ZodDefault<z.ZodEnum<{
                push: "push";
                pull_request: "pull_request";
                manual: "manual";
                workflow: "workflow";
            }>>>;
            pull_request: z.ZodOptional<z.ZodObject<{
                number: z.ZodNumber;
                url: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
        build: z.ZodObject<{
            bun: z.ZodString;
            agentuity: z.ZodString;
            arch: z.ZodString;
            platform: z.ZodString;
        }, z.core.$strip>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export type BuildMetadata = z.infer<typeof BuildMetadataSchema>;
export declare const CreateProjectDeploymentSchema: z.ZodObject<{
    id: z.ZodString;
    orgId: z.ZodString;
    publicKey: z.ZodString;
    buildLogsStreamURL: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const CreateProjectDeploymentResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        orgId: z.ZodString;
        publicKey: z.ZodString;
        buildLogsStreamURL: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type Deployment = z.infer<typeof CreateProjectDeploymentSchema>;
/**
 * Create a new project deployment
 *
 * @param client
 * @param projectId
 * @returns
 */
export declare function projectDeploymentCreate(client: APIClient, projectId: string, deploymentConfig?: z.infer<typeof DeploymentConfig>): Promise<Deployment>;
export declare const DeploymentInstructionsSchema: z.ZodObject<{
    deployment: z.ZodString;
    assets: z.ZodRecord<z.ZodString, z.ZodString>;
}, z.core.$strip>;
export declare const DeploymentInstructionsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        deployment: z.ZodString;
        assets: z.ZodRecord<z.ZodString, z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type DeploymentInstructions = z.infer<typeof DeploymentInstructionsSchema>;
/**
 * Update the deployment with the build metadata
 *
 * @param client
 * @param deploymentId
 * @returns
 */
export declare function projectDeploymentUpdate(client: APIClient, deploymentId: string, deployment: BuildMetadata, signal?: AbortSignal): Promise<DeploymentInstructions>;
export declare const DeploymentCompleteSchema: z.ZodObject<{
    streamId: z.ZodOptional<z.ZodString>;
    publicUrls: z.ZodObject<{
        latest: z.ZodString;
        deployment: z.ZodString;
        custom: z.ZodArray<z.ZodString>;
        vanityDeployment: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        vanityProject: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
}, z.core.$strip>;
export declare const DeploymentCompleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        streamId: z.ZodOptional<z.ZodString>;
        publicUrls: z.ZodObject<{
            latest: z.ZodString;
            deployment: z.ZodString;
            custom: z.ZodArray<z.ZodString>;
            vanityDeployment: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            vanityProject: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type DeploymentComplete = z.infer<typeof DeploymentCompleteSchema>;
export declare const DeploymentStateValue: z.ZodEnum<{
    pending: "pending";
    building: "building";
    deploying: "deploying";
    failed: "failed";
    completed: "completed";
}>;
export type DeploymentState = z.infer<typeof DeploymentStateValue>;
export declare const DeploymentStatusSchema: z.ZodObject<{
    state: z.ZodEnum<{
        pending: "pending";
        building: "building";
        deploying: "deploying";
        failed: "failed";
        completed: "completed";
    }>;
}, z.core.$strip>;
export declare const DeploymentStatusResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        state: z.ZodEnum<{
            pending: "pending";
            building: "building";
            deploying: "deploying";
            failed: "failed";
            completed: "completed";
        }>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type DeploymentStatusResult = z.infer<typeof DeploymentStatusSchema>;
/**
 * Complete the deployment once build is uploaded
 *
 * @param client
 * @param deploymentId
 * @returns
 */
export declare function projectDeploymentComplete(client: APIClient, deploymentId: string, signal?: AbortSignal): Promise<DeploymentComplete>;
/**
 * Get the current provisioning status of a deployment
 *
 * @param client
 * @param deploymentId
 * @returns
 */
export declare function projectDeploymentStatus(client: APIClient, deploymentId: string, signal?: AbortSignal): Promise<DeploymentStatusResult>;
export interface ClientDiagnosticsError {
    type: 'file' | 'general';
    scope: 'typescript' | 'ast' | 'build' | 'bundler' | 'validation' | 'deploy';
    path?: string;
    line?: number;
    column?: number;
    message: string;
    code?: string;
}
export interface ClientDiagnosticsTiming {
    name: string;
    startedAt: string;
    completedAt: string;
    durationMs: number;
}
export interface ClientDiagnostics {
    success: boolean;
    errors: ClientDiagnosticsError[];
    warnings: ClientDiagnosticsError[];
    diagnostics: ClientDiagnosticsTiming[];
    error?: string;
}
export interface DeploymentFailPayload {
    error?: string;
    diagnostics?: ClientDiagnostics;
}
export declare const ClientDiagnosticsErrorSchema: z.ZodObject<{
    type: z.ZodEnum<{
        file: "file";
        general: "general";
    }>;
    scope: z.ZodEnum<{
        build: "build";
        typescript: "typescript";
        ast: "ast";
        bundler: "bundler";
        validation: "validation";
        deploy: "deploy";
    }>;
    path: z.ZodOptional<z.ZodString>;
    line: z.ZodOptional<z.ZodNumber>;
    column: z.ZodOptional<z.ZodNumber>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const ClientDiagnosticsTimingSchema: z.ZodObject<{
    name: z.ZodString;
    startedAt: z.ZodString;
    completedAt: z.ZodString;
    durationMs: z.ZodNumber;
}, z.core.$strip>;
export declare const ClientDiagnosticsSchema: z.ZodObject<{
    success: z.ZodBoolean;
    errors: z.ZodArray<z.ZodObject<{
        type: z.ZodEnum<{
            file: "file";
            general: "general";
        }>;
        scope: z.ZodEnum<{
            build: "build";
            typescript: "typescript";
            ast: "ast";
            bundler: "bundler";
            validation: "validation";
            deploy: "deploy";
        }>;
        path: z.ZodOptional<z.ZodString>;
        line: z.ZodOptional<z.ZodNumber>;
        column: z.ZodOptional<z.ZodNumber>;
        message: z.ZodString;
        code: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    warnings: z.ZodArray<z.ZodObject<{
        type: z.ZodEnum<{
            file: "file";
            general: "general";
        }>;
        scope: z.ZodEnum<{
            build: "build";
            typescript: "typescript";
            ast: "ast";
            bundler: "bundler";
            validation: "validation";
            deploy: "deploy";
        }>;
        path: z.ZodOptional<z.ZodString>;
        line: z.ZodOptional<z.ZodNumber>;
        column: z.ZodOptional<z.ZodNumber>;
        message: z.ZodString;
        code: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    diagnostics: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        startedAt: z.ZodString;
        completedAt: z.ZodString;
        durationMs: z.ZodNumber;
    }, z.core.$strip>>;
    error: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const DeploymentFailPayloadSchema: z.ZodObject<{
    error: z.ZodOptional<z.ZodString>;
    diagnostics: z.ZodOptional<z.ZodObject<{
        success: z.ZodBoolean;
        errors: z.ZodArray<z.ZodObject<{
            type: z.ZodEnum<{
                file: "file";
                general: "general";
            }>;
            scope: z.ZodEnum<{
                build: "build";
                typescript: "typescript";
                ast: "ast";
                bundler: "bundler";
                validation: "validation";
                deploy: "deploy";
            }>;
            path: z.ZodOptional<z.ZodString>;
            line: z.ZodOptional<z.ZodNumber>;
            column: z.ZodOptional<z.ZodNumber>;
            message: z.ZodString;
            code: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        warnings: z.ZodArray<z.ZodObject<{
            type: z.ZodEnum<{
                file: "file";
                general: "general";
            }>;
            scope: z.ZodEnum<{
                build: "build";
                typescript: "typescript";
                ast: "ast";
                bundler: "bundler";
                validation: "validation";
                deploy: "deploy";
            }>;
            path: z.ZodOptional<z.ZodString>;
            line: z.ZodOptional<z.ZodNumber>;
            column: z.ZodOptional<z.ZodNumber>;
            message: z.ZodString;
            code: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        diagnostics: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            startedAt: z.ZodString;
            completedAt: z.ZodString;
            durationMs: z.ZodNumber;
        }, z.core.$strip>>;
        error: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const DeploymentFailResponseSchema: z.ZodObject<{
    state: z.ZodLiteral<"failed">;
}, z.core.$strip>;
export declare const DeploymentFailAPIResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        state: z.ZodLiteral<"failed">;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
/**
 * Report a deployment failure from the client
 *
 * @param client
 * @param deploymentId
 * @param payload - Error message and/or structured diagnostics
 * @returns
 */
export declare function projectDeploymentFail(client: APIClient, deploymentId: string, payload: DeploymentFailPayload): Promise<void>;
//# sourceMappingURL=deploy.d.ts.map