import { z } from 'zod';
import { type APIClient } from '../api';
export declare const CreateProjectRequestSchema: z.ZodObject<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
    orgId: z.ZodString;
    cloudRegion: z.ZodString;
    domains: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const NewProjectSchema: z.ZodObject<{
    id: z.ZodString;
    sdkKey: z.ZodString;
}, z.core.$strip>;
export declare const CreateProjectResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        sdkKey: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type CreateProjectRequest = z.infer<typeof CreateProjectRequestSchema>;
export type CreateProjectResponse = z.infer<typeof CreateProjectResponseSchema>;
export type NewProject = z.infer<typeof NewProjectSchema>;
/**
 * Create a new Project
 *
 * @param client
 * @param body
 * @returns
 */
export declare function projectCreate(client: APIClient, body: CreateProjectRequest): Promise<NewProject>;
//# sourceMappingURL=create.d.ts.map