import { z } from 'zod';
import { APIClient } from '../api';
export declare const OrgEnvUpdateRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
export declare const OrgEnvUpdateResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export type OrgEnvUpdateRequest = z.infer<typeof OrgEnvUpdateRequestSchema>;
export type OrgEnvUpdateResponse = z.infer<typeof OrgEnvUpdateResponseSchema>;
/**
 * Update environment variables and/or secrets for an organization.
 * This will merge the provided env/secrets with existing values.
 * Requires admin/owner role.
 * Keys starting with 'AGENTUITY_' (except AGENTUITY_PUBLIC_) are filtered out.
 */
export declare function orgEnvUpdate(client: APIClient, request: OrgEnvUpdateRequest): Promise<void>;
//# sourceMappingURL=env-update.d.ts.map