/**
 * Log levels for internal SDK logging
 */
export type LogLevel = 'debug' | 'info' | 'warn' | 'error' | 'silent';
/**
 * Internal logger configuration
 */
interface InternalLoggerConfig {
    level: LogLevel;
    context?: Record<string, unknown>;
}
/**
 * Simple internal logger that doesn't depend on other SDK modules
 * This logger is only for SDK internal diagnostics and debugging
 */
declare class InternalLogger {
    private config;
    constructor();
    /**
     * Load configuration from environment variables
     */
    private loadConfig;
    /**
     * Check if a log level should be output based on current configuration
     */
    private shouldLog;
    /**
     * Format a log message with context
     */
    private formatMessage;
    /**
     * Log a debug message
     */
    debug(message: unknown, ...args: unknown[]): void;
    /**
     * Log an info message
     */
    info(message: unknown, ...args: unknown[]): void;
    /**
     * Log a warning message
     */
    warn(message: unknown, ...args: unknown[]): void;
    /**
     * Log an error message
     */
    error(message: unknown, ...args: unknown[]): void;
    /**
     * Update configuration at runtime
     */
    updateConfig(config: Partial<InternalLoggerConfig>): void;
    /**
     * Get current configuration
     */
    getConfig(): InternalLoggerConfig;
    /**
     * Check if logging is enabled
     */
    isEnabled(): boolean;
    /**
     * Create a child logger with additional context
     */
    child(context: Record<string, unknown>): InternalLogger;
}
/**
 * Internal logger for SDK use only
 * This is NOT exported from the main SDK index
 */
export declare const internal: {
    debug: (message: unknown, ...args: unknown[]) => void;
    info: (message: unknown, ...args: unknown[]) => void;
    warn: (message: unknown, ...args: unknown[]) => void;
    error: (message: unknown, ...args: unknown[]) => void;
    updateConfig: (config: Partial<InternalLoggerConfig>) => void;
    getConfig: () => InternalLoggerConfig;
    isEnabled: () => boolean;
    child: (context: Record<string, unknown>) => InternalLogger;
};
export {};
//# sourceMappingURL=internal.d.ts.map