import type { Logger, LogLevel } from '@agentuity/core';
export type ColorScheme = 'light' | 'dark';
/**
 * Console logger implementation
 */
export declare class ConsoleLogger implements Logger {
    level: LogLevel;
    private showTimestamp;
    private colorScheme;
    private colors;
    private showPrefix;
    private context;
    constructor(level?: LogLevel, showTimestamp?: boolean, colorScheme?: ColorScheme, context?: Record<string, unknown>);
    setLevel(level: LogLevel): void;
    setTimestamp(enabled: boolean): void;
    setColorScheme(scheme: ColorScheme): void;
    setShowPrefix(show: boolean): void;
    private shouldLog;
    private formatMessage;
    private log;
    trace(message: unknown, ...args: unknown[]): void;
    debug(message: unknown, ...args: unknown[]): void;
    info(message: unknown, ...args: unknown[]): void;
    warn(message: unknown, ...args: unknown[]): void;
    error(message: unknown, ...args: unknown[]): void;
    fatal(message: unknown, ...args: unknown[]): never;
    child(opts: Record<string, unknown>): Logger;
}
/**
 * Create a new console logger instance
 *
 * @param level - The minimum log level to display
 * @param showTimestamp - Whether to show timestamps in log messages
 * @param colorScheme - The color scheme to use ('light' or 'dark')
 * @param context - Initial context for the logger
 * @returns A new ConsoleLogger instance
 */
export declare function createLogger(level?: LogLevel, showTimestamp?: boolean, colorScheme?: ColorScheme, context?: Record<string, unknown>): Logger;
//# sourceMappingURL=logger.d.ts.map