import type { SortDirection } from '@agentuity/core';
import { z } from 'zod';
import { APIClient } from '../api';
export declare const ThreadSchema: z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    updated_at: z.ZodString;
    deleted: z.ZodBoolean;
    deleted_at: z.ZodNullable<z.ZodString>;
    deleted_by: z.ZodNullable<z.ZodString>;
    org_id: z.ZodString;
    project_id: z.ZodString;
    user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
}, z.core.$strip>;
export declare const ThreadListResponseData: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    updated_at: z.ZodString;
    deleted: z.ZodBoolean;
    deleted_at: z.ZodNullable<z.ZodString>;
    deleted_by: z.ZodNullable<z.ZodString>;
    org_id: z.ZodString;
    project_id: z.ZodString;
    user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
}, z.core.$strip>>;
export declare const ThreadListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        created_at: z.ZodString;
        updated_at: z.ZodString;
        deleted: z.ZodBoolean;
        deleted_at: z.ZodNullable<z.ZodString>;
        deleted_by: z.ZodNullable<z.ZodString>;
        org_id: z.ZodString;
        project_id: z.ZodString;
        user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type ThreadListResponse = z.infer<typeof ThreadListResponseSchema>;
export type ThreadList = z.infer<typeof ThreadListResponseData>;
export type Thread = z.infer<typeof ThreadSchema>;
export type ThreadSortField = 'created' | 'updated';
export interface ThreadListOptions {
    count?: number;
    limit?: number;
    offset?: number;
    sort?: ThreadSortField;
    direction?: SortDirection;
    orgId?: string;
    projectId?: string;
    metadata?: Record<string, unknown>;
}
/**
 * List threads
 *
 * @param client
 * @param options filtering and pagination options
 * @returns
 */
export declare function threadList(client: APIClient, options?: ThreadListOptions): Promise<ThreadList>;
//# sourceMappingURL=list.d.ts.map