import { z } from 'zod';
import { APIClient } from '../api';
export declare const _SessionLogsRequestSchema: z.ZodObject<{
    id: z.ZodString;
}, z.core.$strip>;
export declare const LogSchema: z.ZodObject<{
    body: z.ZodString;
    severity: z.ZodString;
    timestamp: z.ZodString;
}, z.core.$strip>;
export declare const SessionLogsResponse: z.ZodArray<z.ZodObject<{
    body: z.ZodString;
    severity: z.ZodString;
    timestamp: z.ZodString;
}, z.core.$strip>>;
export declare const SessionLogsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        body: z.ZodString;
        severity: z.ZodString;
        timestamp: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
type SessionLogsRequest = z.infer<typeof _SessionLogsRequestSchema>;
export type SessionLog = z.infer<typeof LogSchema>;
export type SessionLogs = SessionLog[];
/**
 * Get logs for a session from the App API
 *
 * @param client APIClient configured for the App API base URL
 * @param request
 * @returns
 */
export declare function sessionLogs(client: APIClient, request: SessionLogsRequest): Promise<SessionLogs>;
export {};
//# sourceMappingURL=logs.d.ts.map